/*
 * Decompiled with CFR 0.152.
 */
package appbot.block;

import appbot.ABBlocks;
import appbot.ae2.ManaKey;
import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.api.util.AECableType;
import appeng.hooks.ticking.TickHandler;
import appeng.me.helpers.BlockEntityNodeListener;
import appeng.me.helpers.IGridConnectedBlockEntity;
import com.google.common.primitives.Ints;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.block.tile.mana.TilePool;

public class FluixPoolBlockEntity
extends TilePool
implements IInWorldGridNodeHost,
IGridConnectedBlockEntity {
    private final Accessor mana = (Accessor)((Object)this);
    private final IManagedGridNode mainNode = GridHelper.createManagedNode((Object)((Object)this), (IGridNodeListener)BlockEntityNodeListener.INSTANCE).setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL}).setVisualRepresentation((ItemLike)ABBlocks.FLUIX_MANA_POOL.get()).setInWorldNode(true).setExposedOnSides(EnumSet.complementOf(EnumSet.of(Direction.UP))).setTagName("proxy");
    private final IActionSource actionSource = IActionSource.ofMachine(() -> ((IManagedGridNode)this.mainNode).getNode());
    private boolean setChangedQueued = false;

    public FluixPoolBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        super(pos, state);
    }

    public boolean isFull() {
        IGrid grid = this.getMainNode().getGrid();
        if (grid == null || !this.getMainNode().isActive()) {
            return true;
        }
        return grid.getStorageService().getInventory().insert(ManaKey.KEY, 1L, Actionable.SIMULATE, this.actionSource) == 0L;
    }

    public void receiveMana(int mana) {
        IGrid grid = this.getMainNode().getGrid();
        if (grid == null || !this.getMainNode().isActive()) {
            return;
        }
        MEStorage storage = grid.getStorageService().getInventory();
        boolean changed = false;
        if (mana > 0) {
            changed = StorageHelper.poweredInsert((IEnergySource)grid.getEnergyService(), (MEStorage)storage, (AEKey)ManaKey.KEY, (long)mana, (IActionSource)this.actionSource) != 0L;
        } else if (mana < 0) {
            boolean bl = changed = StorageHelper.poweredExtraction((IEnergySource)grid.getEnergyService(), (MEStorage)storage, (AEKey)ManaKey.KEY, (long)(-mana), (IActionSource)this.actionSource) != 0L;
        }
        if (changed) {
            this.m_6596_();
            this.markDispatchable();
        }
    }

    public int getCurrentMana() {
        IGrid grid = this.getMainNode().getGrid();
        if (grid == null) {
            return this.mana.getMana();
        }
        if (!this.getMainNode().isActive()) {
            return 0;
        }
        return (int)grid.getStorageService().getInventory().extract(ManaKey.KEY, Integer.MAX_VALUE, Actionable.SIMULATE, this.actionSource);
    }

    public void recalculateManaCap() {
        IGrid grid = this.getMainNode().getGrid();
        if (grid == null) {
            return;
        }
        int oldMana = this.mana.getMana();
        int oldManaCap = this.manaCap;
        if (this.getMainNode().isActive()) {
            MEStorage storage = grid.getStorageService().getInventory();
            this.mana.setMana(Ints.saturatedCast((long)storage.extract(ManaKey.KEY, Integer.MAX_VALUE, Actionable.SIMULATE, this.actionSource)));
            this.manaCap = Ints.saturatedCast((long)(storage.extract(ManaKey.KEY, Integer.MAX_VALUE, Actionable.SIMULATE, this.actionSource) + storage.insert(ManaKey.KEY, Integer.MAX_VALUE, Actionable.SIMULATE, this.actionSource)));
        } else {
            this.mana.setMana(0);
            this.manaCap = 0;
        }
        if (oldMana != this.mana.getMana() || oldManaCap != this.manaCap) {
            this.m_6596_();
            this.markDispatchable();
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.getMainNode().saveToNBT(tag);
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.getMainNode().loadFromNBT(tag);
    }

    @Nullable
    public IGridNode getGridNode(Direction dir) {
        IGridNode node = this.getMainNode().getNode();
        return node != null && node.isExposedOnSide(dir) ? node : null;
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.SMART;
    }

    public IManagedGridNode getMainNode() {
        return this.mainNode;
    }

    public void securityBreak() {
        this.f_58857_.m_46961_(this.f_58858_, true);
    }

    public void saveChanges() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            this.m_6596_();
        } else {
            this.f_58857_.m_151543_(this.f_58858_);
            if (!this.setChangedQueued) {
                TickHandler.instance().addCallable(null, this::setChangedAtEndOfTick);
                this.setChangedQueued = true;
            }
        }
    }

    private void setChangedAtEndOfTick() {
        this.m_6596_();
        this.setChangedQueued = false;
    }

    public void onChunkUnloaded() {
        this.getMainNode().destroy();
    }

    public void onReady() {
        this.getMainNode().create(this.m_58904_(), this.m_58899_());
    }

    public void m_7651_() {
        super.m_7651_();
        this.getMainNode().destroy();
    }

    public void m_6339_() {
        super.m_6339_();
        GridHelper.onFirstTick((BlockEntity)this, FluixPoolBlockEntity::onReady);
    }

    public static interface Accessor {
        public int getMana();

        public void setMana(int var1);
    }
}

